<?php
$type1Total = 0;
$type2Total = 0;

$type1Cases = $DB->query("SELECT * FROM business_case WHERE caseType = 1")->fetchAll(PDO::FETCH_ASSOC);
$type2Cases = $DB->query("SELECT * FROM business_case WHERE caseType = 2")->fetchAll(PDO::FETCH_ASSOC);

foreach ($type1Cases as $type1Case) {
    $type1Total += $type1Case['casePrice'];
}

foreach ($type2Cases as $type2Case) {
    $type2Total += $type2Case['casePrice'];
}

$totalDifference = $type1Total - $type2Total;
$totalDifferenceFormatted = number_format($totalDifference, 0, ',', '.');
?>

<?php
$caseIncomeTotal = 0;

$incomes = $DB->query("SELECT * FROM business_case WHERE caseType = 1 ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

foreach ($incomes as $income) {
    $caseIncomeTotal += $income['casePrice'];
}

$totalIncomeFormatted = number_format($caseIncomeTotal, 0, ',', '.');
?>
<?php
$expenseTotal = 0;

$expenses = $DB->query("SELECT * FROM business_case WHERE caseType = 2")->fetchAll(PDO::FETCH_ASSOC);

foreach ($expenses as $expense) {
    $expenseTotal += $expense['casePrice'];
}

$totalExpenseFormatted = number_format($expenseTotal, 0, ',', '.');
?>

<?php
$remainingDebtTotal = 0;

$orders = $DB->query("SELECT * FROM orders WHERE paymentStatus = 0")->fetchAll(PDO::FETCH_ASSOC);

foreach ($orders as $orderData) {
    $remainingDebtTotal += $orderData['remainingDebt'];
}

$totalRemainingDebtFormatted = number_format($remainingDebtTotal, 0, ',', '.');

$CounttotalOrders = $DB->query("SELECT * FROM orders")->fetchAll(PDO::FETCH_ASSOC);

$totalOrders = count($CounttotalOrders);
$totalOrdersFormatted = number_format($totalOrders, 0, ',', '.');
?>



<?php
$currentMonthStart = date('Y-m-01 00:00:00');
$currentMonthEnd = date('Y-m-t 23:59:59');

$currentMonthStartFormatted = date('Y-m-01 00:00:00');
$currentMonthEndFormatted = date('Y-m-t 23:59:59');

$ordersThisMonth = $DB->prepare("SELECT COUNT(*) as orderCount FROM orders WHERE STR_TO_DATE(orderDate, '%d-%m-%Y %H:%i:%s') BETWEEN ? AND ?");
$ordersThisMonth->execute([$currentMonthStartFormatted, $currentMonthEndFormatted]);
$orderCountResult = $ordersThisMonth->fetch(PDO::FETCH_ASSOC);

$totalOrdersThisMonth = $orderCountResult['orderCount'];
$totalOrdersThisMonthFormatted = number_format($totalOrdersThisMonth, 0, ',', '.');

?>


<?php
$monthlyIncomeTotal = 0;
$monthlyExpenseTotal = 0;

$currentMonth = date('Y-m-01');
$currentMonthEnd = date('Y-m-t');

$incomes = $DB->prepare("SELECT * FROM business_case WHERE caseType = 1 AND caseDate BETWEEN ? AND ?");
$incomes->execute([$currentMonth, $currentMonthEnd]);
$incomeRows = $incomes->fetchAll(PDO::FETCH_ASSOC);

foreach ($incomeRows as $income) {
    $monthlyIncomeTotal += $income['casePrice'];
}

$totalMonthlyIncomeFormatted = number_format($monthlyIncomeTotal, 0, ',', '.');

$expenses = $DB->prepare("SELECT * FROM business_case WHERE caseType = 2 AND caseDate BETWEEN ? AND ?");
$expenses->execute([$currentMonth, $currentMonthEnd]);
$expenseRows = $expenses->fetchAll(PDO::FETCH_ASSOC);

foreach ($expenseRows as $expense) {
    $monthlyExpenseTotal += $expense['casePrice'];
}

$totalMonthlyExpenseFormatted = number_format($monthlyExpenseTotal, 0, ',', '.');
?>


<?php 
if(empty($_GET['month'])){
$ay = date("m");  
$_GET['month'] = date("m");
}else{
$ay = $_GET['month'];      
}
if(empty($_GET['year'])){
$yil = date("Y");  
}else{
$yil = $_GET['year'];  
$_GET['year'] = date("Y"); 
}
if(empty($_GET['date'])){
$caseDate = date("Y-m-d"); 
}else{
$caseDate = $_GET['date'];   
}
?>
<?php 
$gelir = 0;
$caseGelirSorgu = $DB->query("SELECT * from business_case WHERE MONTH(caseDate) = $ay and YEAR(caseDate) = $yil and caseType='1' order by id desc ")->fetchAll(PDO::FETCH_ASSOC); 
foreach ($caseGelirSorgu as $caseGelirSorguCek) {
    $gelir += $caseGelirSorguCek['casePrice'];
}
$gelirFormatted = number_format($gelir, 0, ',', '.');
?>

<?php 
$gider = 0;
$caseGiderSorgu = $DB->query("SELECT * from business_case WHERE MONTH(caseDate) = $ay and YEAR(caseDate) = $yil and caseType='2' order by id desc ")->fetchAll(PDO::FETCH_ASSOC); 
foreach ($caseGiderSorgu as $caseGiderSorguCek) {
    $gider += $caseGiderSorguCek['casePrice'];
}
$giderFormatted = number_format($gider, 0, ',', '.');
?>

<?php
$netKasa = $gelir - $gider;
$netKasaFormatted = number_format($netKasa, 0, ',', '.');
?>
<?php 
$selectedMonthFilter = isset($_GET['month2']) ? $_GET['month2'] : date('m');
$selectedYearFilter = isset($_GET['year2']) ? $_GET['year2'] : date('Y');

$months = [
    '01' => $translations["January"],
    '02' => $translations["February"],
    '03' => $translations["March"],
    '04' => $translations["April"],
    '05' => $translations["May"],
    '06' => $translations["June"],
    '07' => $translations["July"],
    '08' => $translations["August"],
    '09' => $translations["September"],
    '10' => $translations["October"],
    '11' => $translations["November"],
    '12' => $translations["December"],
];

$currentYear = date('Y');
$years = range($currentYear - 6, $currentYear); 

$currentMonthStartFilter = sprintf('%04d-%02d-01 00:00:00', $selectedYearFilter, $selectedMonthFilter);
$currentMonthEndFilter = sprintf('%04d-%02d-%02d 23:59:59', $selectedYearFilter, $selectedMonthFilter, cal_days_in_month(CAL_GREGORIAN, $selectedMonthFilter, $selectedYearFilter));

$getOrdersThisMonthFilter = $DB->prepare("SELECT COUNT(*) as orderCount FROM orders WHERE STR_TO_DATE(orderDate, '%d-%m-%Y %H:%i:%s') BETWEEN ? AND ?");
$getOrdersThisMonthFilter->execute([$currentMonthStartFilter, $currentMonthEndFilter]);

$orderCountResultFilter = $getOrdersThisMonthFilter->fetch(PDO::FETCH_ASSOC);

$totalOrdersThisMonthFilter = $orderCountResultFilter['orderCount'];

$totalRemainingDebt = 0;

$ordersThisMonthQuery = $DB->prepare("SELECT SUM(remainingDebt) as totalDebt FROM orders WHERE paymentStatus=0 AND STR_TO_DATE(orderDate, '%d-%m-%Y %H:%i:%s') BETWEEN ? AND ?");
$ordersThisMonthQuery->execute([$currentMonthStartFilter, $currentMonthEndFilter]);
$orderDebtResult = $ordersThisMonthQuery->fetch(PDO::FETCH_ASSOC);

$totalRemainingDebtThisMonth = $orderDebtResult['totalDebt'];

$totalRemainingDebtThisMonthFormatted = number_format($totalRemainingDebtThisMonth, 0, ',', '.');

$totalOrderIncome = 0;

$ordersThisMonthQuery = $DB->prepare("SELECT SUM(orderFiyat) as totalIncome FROM orders WHERE paymentStatus=1 AND STR_TO_DATE(orderDate, '%d-%m-%Y %H:%i:%s') BETWEEN ? AND ?");
$ordersThisMonthQuery->execute([$currentMonthStartFilter, $currentMonthEndFilter]);
$orderIncomeResult = $ordersThisMonthQuery->fetch(PDO::FETCH_ASSOC);

$totalOrderIncome = $orderIncomeResult['totalIncome'];

$totalOrderIncomeFormatted = number_format($totalOrderIncome, 0, ',', '.');
?>











	<!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->	
			<div class="page-titles">
				<ol class="breadcrumb">
					<li><h5 class="bc-title"><?=$translations["Dashboard"]?></h5></li>
				</ol>
			</div>
			<div class="container-fluid">
				<div class="row">
					<div class="col-xl-12 wid-100">
						<div class="row">
						<?php if ($settings['caseSystem'] == '1') { ?>
						<div class="col-xl-3  col-lg-6 col-sm-6">
						<div class="widget-stat card">
							<div class="card-body p-4">
								<div class="media ai-icon">
									<span class="me-3 bgl-primary text-primary">
										<!-- <i class="ti-user"></i> -->
										<svg id="icon-customers" xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user">
											<path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
											<circle cx="12" cy="7" r="4"></circle>
										</svg>
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeCase"]?></p>
										<h4 class="mb-0"><?=$totalDifferenceFormatted?>₺</h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
					<?php } ?>
					<?php if ($settings['caseSystem'] == '1') { ?>
                    <div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body p-4">
								<div class="media ai-icon">
                                <span class="me-3 bgl-success text-success">₺
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeTotalIncome"]?></p>
										<h4 class="mb-0"><?=$totalIncomeFormatted?>₺</h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
					<?php } ?>
					<?php if ($settings['caseSystem'] == '1') { ?>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body  p-4">
								<div class="media ai-icon">
									<span class="me-3 bgl-danger text-danger">₺
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeTotalExpense"]?></p>
										<h4 class="mb-0"><?=$totalExpenseFormatted?>₺</h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
					<?php } ?>
					<?php if ($settings['orderSystem'] == '1') { ?>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body p-4">
								<div class="media ai-icon">
									<span class="me-3 bgl-warning text-warning">
									<svg id="rocket-icon" class="my-2" viewBox="0 0 24 24" width="30" height="30" stroke="currentColor" stroke-width="1" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
									<line x1="3" y1="6" x2="21" y2="6"></line>
									<path d="M16 10a4 4 0 0 1-8 0"></path>
								</svg>
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeTotalOrder"]?></p>
										<h4 class="mb-0"><?=$totalOrdersFormatted?></h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
					<?php } ?>
					<?php if ($settings['orderSystem'] == '1') { ?>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body  p-4">
								<div class="media ai-icon">
                                <span class="me-3 bgl-danger text-danger">₺
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeRemainingDebt"]?></p>
										<h4 class="mb-0"><?=$totalRemainingDebtFormatted?>₺</h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
<?php } ?>

<?php if ($settings['caseSystem'] == '1') { ?>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body p-4">
								<div class="media ai-icon">
                                <span class="me-3 bgl-success text-success">₺
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeMonthlyIncome"]?></p>
										<h4 class="mb-0"><?=$totalMonthlyIncomeFormatted?>₺</h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body  p-4">
								<div class="media ai-icon">
                                <span class="me-3 bgl-danger text-danger">₺
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeMonthlyExpense"]?></p>
										<h4 class="mb-0"><?=$totalMonthlyExpenseFormatted?>₺</h4>
                                        
									</div>
								</div>
							</div>
						</div>
                    </div>
					<?php } ?>
					<?php if ($settings['orderSystem'] == '1') { ?>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                        <div class="widget-stat card">
							<div class="card-body p-4">
								<div class="media ai-icon">
									<span class="me-3 bgl-warning text-warning">
									<svg id="rocket-icon" class="my-2" viewBox="0 0 24 24" width="30" height="30" stroke="currentColor" stroke-width="1" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
									<line x1="3" y1="6" x2="21" y2="6"></line>
									<path d="M16 10a4 4 0 0 1-8 0"></path>
								</svg>
									</span>
									<div class="media-body">
										<p class="mb-1"><?=$translations["homeMonthlyOrder"]?></p>
										<h4 class="mb-0"><?=$totalOrdersThisMonthFormatted?></h4>
									</div>
								</div>
							</div>
						</div>
                    </div>
                    </div>
                    </div>
					<?php } ?>
					<?php if ($settings['caseSystem'] == '1') { ?>
					<div class="col-xl-3  col-lg-6 col-sm-6">
                            <div class="card">
                                <div class="card-header flex-column align-items-start">
                                    <div class="badge badge-primary">
									<?=$translations["homeCaseFilter"]?>
                                    </div>
                                    
                                    
                                </div>

                                <form style="padding: 20px;" action="" method="get">
                                        <select class="form-control mt-1"  name="month" id="month" style="margin-right:5px;">
                                            <option <?php if($_GET['month']=='1'){echo 'selected';} ?> value="1"><?=$translations["January"]?></option>
                                            <option <?php if($_GET['month']=='2'){echo 'selected';} ?> value="2"><?=$translations["February"]?></option>
                                            <option <?php if($_GET['month']=='3'){echo 'selected';} ?> value="3"><?=$translations["March"]?></option>
                                            <option <?php if($_GET['month']=='4'){echo 'selected';} ?> value="4"><?=$translations["April"]?></option>
                                            <option <?php if($_GET['month']=='5'){echo 'selected';} ?> value="5"><?=$translations["May"]?></option>
                                            <option <?php if($_GET['month']=='6'){echo 'selected';} ?> value="6"><?=$translations["June"]?></option>
                                            <option <?php if($_GET['month']=='7'){echo 'selected';} ?> value="7"><?=$translations["July"]?></option>
                                            <option <?php if($_GET['month']=='8'){echo 'selected';} ?> value="8"><?=$translations["August"]?></option>
                                            <option <?php if($_GET['month']=='9'){echo 'selected';} ?> value="9"><?=$translations["September"]?></option>
                                            <option <?php if($_GET['month']=='10'){echo 'selected';} ?> value="10"><?=$translations["October"]?></option>
                                            <option <?php if($_GET['month']=='11'){echo 'selected';} ?> value="11"><?=$translations["November"]?></option>
                                            <option <?php if($_GET['month']=='12'){echo 'selected';} ?> value="12"><?=$translations["December"]?></option>
                     
                                        </select>
                                        <?php 
                                        $currently_selected = date('Y'); 
                                        $earliest_year = 2018; 
                                        $latest_year = date('Y'); ?>
                                        <select class="form-control mt-1"  name="year" id="year" style="margin-right:5px;">
                                        <?php 
                                        foreach ( range( $latest_year, $earliest_year ) as $i ) {?>
                                        <option <?php if($currently_selected==$i){echo 'selected';} ?> value="<?=$i?>"><?=$i?></option>
                                        <?php }?>
                                        </select>
                                       

                                        <button style="width: 100%;" class="btn btn-danger btn-add-record mt-2" tabindex="0"
                                                aria-controls="DataTables_Table_0" type="submit">
                                                <span><?=$translations["filter"]?></span>
                                            </button>
                                            <a href="../home" style="width: 100%;" class="btn btn-danger btn-add-record mt-2" tabindex="0"
                                                aria-controls="DataTables_Table_0" >
                                                <span><?=$translations["reset"]?></span>
                                                </a>
                                    </form>
                                
                        </div>
                        <!-- Orders Chart Card ends -->
                    </div>
                    

                          <!-- Case Chart Card starts -->
                          <div class="col-xl-3  col-lg-6 col-sm-6">
                            <div class="card">
                                <div style="display: flex;">
                                <div style="width:50%" class="card-header flex-column align-items-start">
                                    <div class="bgl-success text-success">
                                        <div class="avatar-content">
                                            <svg style="width: 2rem;height: 2rem;" xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="green" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-down-right"><line x1="7" y1="7" x2="17" y2="17"></line><polyline points="17 7 17 17 7 17"></polyline></svg>
                                        </div>
                                    </div>
                                    <h2 class="fw-bolder mt-1"><?=$gelirFormatted?>₺</h2>
                                    <p class="card-text"><b><?=$translations["homeMonthlyIncome"]?></b></p>
                                </div>
                                <div style="width:50%" class="card-header flex-column align-items-start">
                                    <div class="bgl-danger text-danger">
                                        <div class="avatar-content">
                                         <svg style="width: 2rem;height: 2rem;"  xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-up-right"><line x1="7" y1="17" x2="17" y2="7"></line><polyline points="7 7 17 7 17 17"></polyline></svg>                                        </div>
                                    </div>
                                    <h2 class="fw-bolder mt-1"><?=$giderFormatted?>₺</h2>
                                    <p class="card-text"><b><?=$translations["homeMonthlyExpense"]?></b></p>
                                </div>
                                </div>
                                <div style="width:100%" class="card-header flex-column align-items-start">
                                    <div class="bgl-warning text-warning">
                                        <div class="avatar-content">
                                        <svg style="width: 2rem;height: 2rem;" width="64" height="64" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7 12L17 12" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                        </div>
                                    </div>
                                    <h2 class="fw-bolder mt-1"><?=$netKasaFormatted?>₺</h2>
                                    <p class="card-text"><b><?=$translations["homeMonthlyCase"]?></b></p>
                                </div>
                            <div class="resize-triggers"><div class="expand-trigger"><div style="width: 340px; height: 239px;"></div></div><div class="contract-trigger"></div></div></div>
                    </div>
					<?php } ?>
					<?php if ($settings['orderSystem'] == '1') { ?>
					<div class="col-xl-3 col-lg-6 col-sm-6">
    <div class="card">
        <div class="card-header flex-column align-items-start">
            <div class="badge badge-primary">
			<?=$translations["homeOrderFilter"]?>
            </div>
        </div>
        <form style="padding: 20px;" action="" method="get">
            <select class="form-control mt-1" name="month2" id="monthSelect" style="margin-right:5px;">
                <?php foreach ($months as $month => $monthName): ?>
                    <option value="<?php echo $month; ?>" <?php if ($selectedMonthFilter == $month) echo 'selected'; ?>><?php echo $monthName; ?></option>
                <?php endforeach; ?>
            </select>
            <select class="form-control mt-1" name="year2" id="yearSelect" style="margin-right:5px;">
                <?php foreach ($years as $year): ?>
                    <option value="<?php echo $year; ?>" <?php if ($selectedYearFilter == $year) echo 'selected'; ?>><?php echo $year; ?></option>
                <?php endforeach; ?>
            </select>

            <button style="width: 100%;" class="btn btn-danger btn-add-record mt-2" tabindex="0" aria-controls="DataTables_Table_0" type="submit">
                <span><?=$translations["filter"]?></span>
            </button>
            <a href="../home" style="width: 100%;" class="btn btn-danger btn-add-record mt-2" tabindex="0" aria-controls="DataTables_Table_0">
                <span><?=$translations["reset"]?></span>
            </a>
        </form>
    </div>
</div>

<div class="col-xl-3  col-lg-6 col-sm-6">
                            <div class="card">
                                <div style="display: flex;">
                                <div style="width:50%" class="card-header flex-column align-items-start">
                                    <div class="bgl-success text-success">
                                        <div class="avatar-content">
                                            <svg style="width: 2rem;height: 2rem;" xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="green" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-down-right"><line x1="7" y1="7" x2="17" y2="17"></line><polyline points="17 7 17 17 7 17"></polyline></svg>
                                        </div>
                                    </div>
                                    <h2 class="fw-bolder mt-1"><?=$totalOrderIncomeFormatted ?>₺</h2>
                                    <p class="card-text"><b><?=$translations["homeMonthlyOrderIncome"]?></b></p>
                                </div>
                                <div style="width:50%" class="card-header flex-column align-items-start">
                                    <div class="bgl-danger text-danger">
                                        <div class="avatar-content">
                                         <svg style="width: 2rem;height: 2rem;"  xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-up-right"><line x1="7" y1="17" x2="17" y2="7"></line><polyline points="7 7 17 7 17 17"></polyline></svg>                                        </div>
                                    </div>
                                    <h2 class="fw-bolder mt-1"><?=$totalRemainingDebtThisMonthFormatted?>₺</h2>
                                    <p class="card-text"><b><?=$translations["homeMonthlyRemainingDebt"]?></b></p>
                                </div>
                                </div>
                                <div style="width:100%" class="card-header flex-column align-items-start">
                                    <div class="bgl-warning text-warning">
                                        <div class="avatar-content">
                                        <svg style="width: 2rem;height: 2rem;" width="64" height="64" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7 12L17 12" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                        </div>
                                    </div>
                                    <h2 class="fw-bolder mt-1"><?php echo $totalOrdersThisMonthFilter; ?></h2>
                                    <p class="card-text"><b><?=$translations["homeMonthlyOrderNumber"]?></b></p>
                                </div>
                            <div class="resize-triggers"><div class="expand-trigger"><div style="width: 340px; height: 239px;"></div></div><div class="contract-trigger"></div></div></div>
                    </div>
</div>
<?php } ?>
<?php if ($settings['orderSystem'] == '1') { ?>
<?php 
if ($userChk['isAdmin'] == '1' || $userChk['porderView'] == '1') { ?>
					<div class="col-xl-12 bst-seller">
						<div class="card">
							<div class="card-header border-0">
								<h4 class="heading mb-0"><?=$translations["homeLast10Order"]?></h4>
				
							</div>
							<div class="card-body p-0">
								<div class="table-responsive active-projects active-projects ItemsCheckboxSec selling-product shorting ">
									<table id="product-tbl" class="table ">
										<thead>
										<tr>
                                                            	<th style="width: 42px;">ID</th>
                                                                <th style="width: 50px;"><?=$translations["orderCategory"]?></th>
																<th style="width: 125px;"><?=$translations["orderProduct"]?></th>
																<th style="width: 75px;"><?=$translations["orderMember"]?></th>
																<th style="width: 75px;"><?=$translations["orderPrice"]?></th>
																<th style="width: 50px;"><?=$translations["orderDate"]?></th>
                                                                <th style="width: 55px;"><?=$translations["remainingDebt"]?></th>
                                                                <?php if ($userChk['porderEdit'] == '1' || $userChk['porderDell'] == '1' || $userChk['isAdmin'] == '1') { ?>
                                                                    <th style="width: 50px;"><?=$translations["edit"]?></th>
                                                                <?php } else { ?>
                                                                    <th style="width: 50px;"></th>
                                                                <?php } ?>
                                                                


															</tr>
														</thead>
														<tbody id="list">
														<?php $total ='0'; ?>
                                    <?php $page = intval(@$_GET['page']);
                                    if (!$page) {
                                        $page = 1;
                                    }
                                    $bak = $DB->prepare("select * from orders");
                                    $bak->execute(array());
                                    $toplam= $bak->rowCount();
                                    $limit = 10;
                                    $goster = $page*$limit-$limit;
                                    $sayfasayisi = ceil($toplam/$limit);
                                    $forlimit = 1; ?>
                                     <?php $order = $DB->query("SELECT * from orders order by id desc limit $goster,$limit")->fetchAll(PDO::FETCH_ASSOC); 
                                    foreach ($order as $orderData) {
                                        ?>
															<tr>
															<td class="sorting_1">
                                            #<?=$orderData['id']?></a>
                                        </td>
                                        <td>
    <h6>
    <?php
        $urunParcala = explode(",", $orderData['products']); 
        $urunSayi = count($urunParcala);
        $i = 0;
        foreach($urunParcala as $urunParcalaCek){
            $urunDetay = $DB->query("SELECT c.ad AS kategori_ad FROM products p INNER JOIN category c ON p.category = c.id WHERE p.id = $urunParcalaCek")->fetch(PDO::FETCH_ASSOC);  
            $i++;
            echo $urunDetay['kategori_ad'];
            if($i != $urunSayi) {
                echo ", ";
            }
        }
    ?>
    </h6>
</td>
										<td>
    <h6>
    <?php
        $urunParcala = explode(",", $orderData['products']); 
        $urunSayi = count($urunParcala);
        $i = 0;
        foreach($urunParcala as $urunParcalaCek){
            $urunDetay = $DB->query("SELECT p.ad AS urun_ad FROM products p WHERE p.id = $urunParcalaCek")->fetch(PDO::FETCH_ASSOC);  
            $i++;
            echo $urunDetay['urun_ad'];
            if($i != $urunSayi) {
                echo ", ";
            }
        }
    ?>
    </h6>
</td>



										<td>
                                        <h6><?php
                                                        $memberID = $orderData['memberID'];
                                                        $musteriDetay = $DB->query("select * from members where id='$memberID'")->fetch(PDO::FETCH_ASSOC);  
                                                        ?>
                                                        <?php echo $musteriDetay['name'];?></h6>
                                        </td>
										<td>
                                        <h6><?=$orderData['orderFiyat']?>₺</h6>
                                        </td>
										<td><?=$orderData['orderDate']?></td>
                                        <td>
                                        <?php
$remainingDebt = $orderData['remainingDebt'];
$debtDisplay = ($remainingDebt < 0) ? substr($remainingDebt, 1) : $remainingDebt;
$debtColor = ($remainingDebt <= 0) ? 'green' : 'red';
?>
<a style="color:<?=$debtColor?>"><?=$debtDisplay?> ₺</a>

                                        </td>
                                        <td>
										<div class="d-flex">
                                        <?php if ($userChk['porderEdit'] == '1' || $userChk['isAdmin'] == '1') { ?>					
                                        <a href="order/<?=$orderData['id']?>" class="btn btn-primary shadow btn-xs sharp me-1"><i data-feather="edit-2" class="feather-icon-edit"></i></a>
                                        <?php } ?>
<?php if ($userChk['porderDell'] == '1' || $userChk['isAdmin'] == '1') { ?>						
                                        <a id="orderDell" orderID="<?=$orderData['id']?>" class="orderDell btn btn-danger shadow btn-xs sharp"><i data-feather="trash-2" class="feather-icon-trash"></i></a>
                                        <?php } ?>		
                                    </div>	</td>
									</tr>
										<?php } ?>
														</tbody>
													</table>
												</div>
									</div>	
									</div>	
									</div>	
									<?php } ?>
									<?php } ?>
									</div>	
									</div>	
									</div>	
									</div>	
									</div>	
					
        <!--**********************************
            Content body end
        ***********************************-->